/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __FSL_MISC_UTILITIES_H__
#define __FSL_MISC_UTILITIES_H__

#include <stdint.h>

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*! @brief Min/max macros */
#if !defined(MIN)
    #define MIN(a, b) ((a) < (b) ? (a) : (b))
#endif

#if !defined(MAX)
    #define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

/*! @brief Computes the number of elements in an array.*/
#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

/*! @brief Byte swap macros */
#define BSWAP_16(x)   (uint16_t)((((x) & 0xFF00) >> 0x8) | (((x) & 0xFF) << 0x8))
#define BSWAP_32(val) (uint32_t)((BSWAP_16((uint32_t)(val) & (uint32_t)0xFFFF) << 0x10) |  \
                                 (BSWAP_16((uint32_t)((val) >> 0x10))))


#ifdef NDEBUG           /* required by ANSI standard */
#define debug_assert(expression)  ((void)0)
#else
#define debug_assert(expression)  ((expression) ? (void)0 : assert_func (__FILE__, __LINE__, NULL, #expression))
#endif

#define ASSERT(x)   debug_assert(x)

/*!
 * @brief Print out failure messages.
 *
 * @param file A pointer to assert failure file.
 * @param line Assert failure line number.
 * @param func A pointer to assert failure function name.
 * @param failedExpr A pointer to assert failure expression.
 *
 */
void assert_func(const char *file, int line, const char *func, const char *failedExpr);

#endif /* __FSL_MISC_UTILITIES_H__ */
/*******************************************************************************
 * EOF
 ******************************************************************************/

